<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            Add Link
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->

<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">

        <?php if (isset($originalLinkExist)) {
    ?>
            <?php $short_link = $this->Html->url('/' . $originalLinkExist[ 'Link' ][ 'alias' ], true);
    ?>

            <div class="alert alert-info alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <h4><i class="fa fa-info-circle"></i> This link already exists</h4>
                <pre><?php echo $short_link;
    ?></pre>
            </div>

        <?php 
} ?>

        <?php
        echo $this->Form->create('Link', array(
            'inputDefaults' => array(
                'label' => false,
                'div'   => false,
                'class' => 'form-control placeholder-no-fix',
                'error' => array(
                    'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
                )
            )
        ));
        ?>

        <div class="form-group <?php echo($this->Form->isFieldError('long_url') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkLongUrl">Long URL</label>
            <?php echo $this->Form->input('long_url'); ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('alias') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkAlias">Alias</label>
            <?php echo $this->Form->input('alias', array( 'required' => false )); ?>
        </div>

        <button type="button" class="btn btn-default btn-xs advanced">Advanced</button>
        <div class="advanced-div" style="display: none;">


            <div class="form-group <?php echo($this->Form->isFieldError('password') ? 'has-error' : ''); ?>">
                <label class="control-label" for="LinkPassword">Password</label>
                <?php echo $this->Form->input('password'); ?>
            </div>

            <div class="form-group <?php echo($this->Form->isFieldError('redirection_type') ? 'has-error' : ''); ?>">
                <label class="control-label" for="LinkRedirectionType">Redirection Type</label>
                <?php
                $redirections = array(
                    '0' => 'Default',
                    '1' => 'Direct',
                    '2' => 'Counter Page'
                );

                $redirect_options = array('0' => 'Default');
                foreach ($user_plan[ 'Plan' ][ 'redirections' ] as $redirect) {
                    $redirect_options[ $redirect ] = $redirections[ $redirect ];
                }

                echo $this->Form->input('redirection_type', array( 'options' => $redirections, 'value' => 0 ));
                ?>
            </div>

            <div class="form-group <?php echo($this->Form->isFieldError('bundle_id') ? 'has-error' : ''); ?>">
                <label class="control-label" for="LinkBundleId">Bundle</label>
                <?php
                echo $this->Form->input('bundle_id', array(
                    'options' => $bundles,
                    'empty'   => 'Select Bundle'
                ));
                ?>
            </div>


        </div>
        <?php echo $this->Form->end(array( 'label' => 'Submit', 'class' => 'btn btn-primary btn-lg pull-right' )); ?>


    </div>
</div>
<!-- END PAGE CONTENT-->